#ifndef KRAMPUS_INC_ENGINE_HPP
#define KRAMPUS_INC_ENGINE_HPP

#include <string>
#include <iostream>

#include <allegro5/allegro.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_acodec.h>
#include <allegro5/allegro_primitives.h>

using std::cout;
using std::string;

class Engine {

  public:

    Engine(void);

    bool isKey(const int);

    bool isRunning(void);

    bool isKeyPressed(void);

    bool isKeyReleased(void);

    bool isRenderPhase(void);

    bool isUpdatePhase(void);

    void flipPhase(void);

    void stopTimer(void);

    void initialize(const unsigned int, const unsigned int, const string);

    void startTimer(void);

    void checkReturn(const bool);

    void flipDisplay(void);

    void reserveSamples(const unsigned int);

    void checkEventQueue(void);

    void setDisplayScale(const float scale);

    void setResourcePath(const string);

    void destroyResources(void);

    void manageWindowEvents(void);

    ALLEGRO_EVENT &getEvent(void);

    void end(void);

  private:

    int w_width;
    int w_height;

    bool render;
    bool is_running;
    bool is_updating;

    ALLEGRO_EVENT event;

    ALLEGRO_TIMER *timer;
    ALLEGRO_DISPLAY *display;
    ALLEGRO_EVENT_QUEUE *event_queue;
};

#endif
